'use client'
import Link from "next/link";
import React, {useState} from "react";
import { useRouter } from "next/navigation";
import { CredentialLogin } from "../../lib/actions";
//import { signIn } from "../../../auth";

function Form(props) {
    const [formData, setForm] = useState({
        email: '',
        password:''
    })
    const [loading, setLoading] = useState(false);
    const [error,setError] = useState({email:'',password:'', all:""})
    
    const router = useRouter()

    const handleSubmit = async(e)=> {
         e.preventDefault();
         if(!formData.email){
            setError({...error,email:'Email is required'})
         }
         if(!formData.password){
            setError({...error,password:'Email is required'})
         }
          // CredentialLogin(formData)
         const res = await CredentialLogin(formData);
         setLoading(true)
         if(res.error){
            console.log(res.error)
            setError({...error,all:'Check your Login Details'})
        }
         else{
router.push('/booking')       }
    }
  return (

         
    <div className="flex items-center justify-center px-4 py-10 bg-white sm:px-6 lg:px-8 sm:py-16 lg:py-24">
    <div className="xl:w-full xl:max-w-sm 2xl:max-w-md xl:mx-auto">
      <h2 className="text-3xl font-bold leading-tight text-black sm:text-4xl">
        Sign In
      </h2>
      <p className="mt-2 text-base text-gray-600">
        You don't have an account?{" "}
        <Link
          href="/register"
          title=""
          className="font-medium text-blue-600 transition-all duration-200 hover:text-blue-700 focus:text-blue-700 hover:underline"
        >
          Register
        </Link>
      </p>
      {error.all && <p className='text-sm text-red-500 mt-1'>{error.all}</p>}

      <form onSubmit={handleSubmit} method="POST" className="mt-8">
        <div className="space-y-5">
         

          <div>
            <label
              for=""
              className="text-base font-medium text-gray-900"
            >
              {" "}
              Email address{" "}
            </label>
            <div className="mt-2.5 relative text-gray-400 focus-within:text-gray-600">
              <div className="absolute inset-y-0 left-0 flex items-center pl-3 pointer-events-none">
                <svg
                  className="w-5 h-5"
                  xmlns="http://www.w3.org/2000/svg"
                  fill="none"
                  viewBox="0 0 24 24"
                  stroke="currentColor"
                >
                  <path
                    stroke-linecap="round"
                    stroke-linejoin="round"
                    stroke-width="2"
                    d="M16 12a4 4 0 10-8 0 4 4 0 008 0zm0 0v1.5a2.5 2.5 0 005 0V12a9 9 0 10-9 9m4.5-1.206a8.959 8.959 0 01-4.5 1.207"
                  />
                </svg>
              </div>

              <input
                type="email"
                name="email"
                id="email"
                value = {formData.email}
                onChange = {(e)=>setForm({...formData,email:e.target.value})}
                placeholder="Enter email to get started"
                className="block w-full py-4 pl-10 pr-4 text-black placeholder-gray-500 transition-all duration-200 border border-gray-200 rounded-md bg-gray-50 focus:outline-none focus:border-blue-600 focus:bg-white caret-blue-600"
              />
             {error.email && <p className='text-sm text-red-500 mt-1'>{error.email}</p>}

            </div>
          </div>

          <div>
            <label
              for=""
              className="text-base font-medium text-gray-900"
            >
              {" "}
              Password{" "}
            </label>
            <div className="mt-2.5 relative text-gray-400 focus-within:text-gray-600">
              <div className="absolute inset-y-0 left-0 flex items-center pl-3 pointer-events-none">
                <svg
                  className="w-5 h-5"
                  xmlns="http://www.w3.org/2000/svg"
                  fill="none"
                  viewBox="0 0 24 24"
                  stroke="currentColor"
                >
                  <path
                    stroke-linecap="round"
                    stroke-linejoin="round"
                    stroke-width="2"
                    d="M12 11c0 3.517-1.009 6.799-2.753 9.571m-3.44-2.04l.054-.09A13.916 13.916 0 008 11a4 4 0 118 0c0 1.017-.07 2.019-.203 3m-2.118 6.844A21.88 21.88 0 0015.171 17m3.839 1.132c.645-2.266.99-4.659.99-7.132A8 8 0 008 4.07M3 15.364c.64-1.319 1-2.8 1-4.364 0-1.457.39-2.823 1.07-4"
                  />
                </svg>
              </div>

              <input
                type="password"
                name="password"
                id="password"
                value = {formData.password}
                onChange = {(e)=>setForm({...formData,password:e.target.value})}
                placeholder="Enter your password"
                className="block w-full py-4 pl-10 pr-4 text-black placeholder-gray-500 transition-all duration-200 border border-gray-200 rounded-md bg-gray-50 focus:outline-none focus:border-blue-600 focus:bg-white caret-blue-600"
              />
              {error.password && <p className='text-sm text-red-500 mt-1'>{error.password}</p>}
            </div>
          </div>

          <div>
            <button
            disabled={loading}
              type="submit"
              className="inline-flex items-center justify-center w-full px-4 py-4 text-base font-semibold text-white transition-all duration-200 border border-transparent rounded-md bg-gradient-to-r from-fuchsia-600 to-blue-600 focus:outline-none hover:opacity-80 focus:opacity-80"
            >
             {loading? 'Logging in...':"Sign In"}
            </button>
          </div>
        </div>
      </form>

      <div className="mt-3 space-y-3">
        

        <button
          type="button"
          className="relative inline-flex items-center justify-center w-full px-4 py-4 text-base font-semibold text-gray-700 transition-all duration-200 bg-white border-2 border-gray-200 rounded-md hover:bg-gray-100 focus:bg-gray-100 hover:text-black focus:text-black focus:outline-none"
        >
          <div className="absolute inset-y-0 left-0 p-4">
            <svg
              className="w-6 h-6 text-[#2563EB]"
              xmlns="http://www.w3.org/2000/svg"
              viewBox="0 0 24 24"
              fill="currentColor"
            >
              <path d="M13.397 20.997v-8.196h2.765l.411-3.209h-3.176V7.548c0-.926.258-1.56 1.587-1.56h1.684V3.127A22.336 22.336 0 0 0 14.201 3c-2.444 0-4.122 1.492-4.122 4.231v2.355H7.332v3.209h2.753v8.202h3.312z"></path>
            </svg>
          </div>
          Sign up with Facebook
        </button>
      </div>

      <p className="mt-5 text-sm text-gray-600">
        This site is protected by reCAPTCHA and the Google{" "}
        <a
          href="#"
          title=""
          className="text-blue-600 transition-all duration-200 hover:underline hover:text-blue-700"
        >
          Privacy Policy
        </a>{" "}
        &
        <a
          href="#"
          title=""
          className="text-blue-600 transition-all duration-200 hover:underline hover:text-blue-700"
        >
          Terms of Service
        </a>
      </p>
    </div>
  </div>
  );
}

export default Form;
