import React from 'react'
import { useCart } from '../../context/CartProvider'
import { useRouter } from 'next/navigation'

export default function CartItem({item, index}) {
    const {removeFromCart, removeProduct} = useCart()
    console.log(item)
    const {count,product}=item
    const {title,firm, price } = product
    const router = useRouter()

    const remove =()=>{
        removeFromCart(product,1)}
  return (
    <li class="flex items-center gap-4" key={index}>
              <img
                src="image/team-pic.jfif"
                alt=""
                class="size-16 rounded object-cover"
              />
  
              <div>
                <h3 class="text-sm text-gray-900">{title}</h3>
  
                <dl class="mt-0.5 space-y-px text-[10px] text-gray-600">
                  <div>
                    <dt class="inline">Price:</dt>
                    <dd class="inline">5000</dd>
                  </div>
  
                  <div>
                    <dt class="inline">Firm:</dt>
                    <dd class="inline">{firm}</dd>
                  </div>
                </dl>
              </div>
  
              <div class="flex flex-1 items-center justify-end gap-2">
                <form>
                  <label htmlFor="Line1Qty" class="sr-only"> Quantity </label>
  
                  <input
                    type="number"
                    min="1"
                    value={count}
                    id="Line1Qty"
                    class="h-8 w-12 rounded border-gray-200 bg-gray-50 p-0 text-center text-xs text-gray-600 [-moz-appearance:_textfield] focus:outline-none [&::-webkit-inner-spin-button]:m-0 [&::-webkit-inner-spin-button]:appearance-none [&::-webkit-outer-spin-button]:m-0 [&::-webkit-outer-spin-button]:appearance-none"
                  />
                </form>
  
                <button onClick={()=>removeProduct(product)} class="text-gray-600 transition hover:text-red-600">
                  <span class="sr-only">Remove item</span>
  
                  <svg
                    xmlns="http://www.w3.org/2000/svg"
                    fill="none"
                    viewBox="0 0 24 24"
                    stroke-width="1.5"
                    stroke="currentColor"
                    class="h-4 w-4"
                  >
                    <path
                      stroke-linecap="round"
                      stroke-linejoin="round"
                      d="M14.74 9l-.346 9m-4.788 0L9.26 9m9.968-3.21c.342.052.682.107 1.022.166m-1.022-.165L18.16 19.673a2.25 2.25 0 01-2.244 2.077H8.084a2.25 2.25 0 01-2.244-2.077L4.772 5.79m14.456 0a48.108 48.108 0 00-3.478-.397m-12 .562c.34-.059.68-.114 1.022-.165m0 0a48.11 48.11 0 013.478-.397m7.5 0v-.916c0-1.18-.91-2.164-2.09-2.201a51.964 51.964 0 00-3.32 0c-1.18.037-2.09 1.022-2.09 2.201v.916m7.5 0a48.667 48.667 0 00-7.5 0"
                    />
                  </svg>
                </button>
                <button
          onClick={()=>router.push(`chat?seller=${firm}`)}
            type="button"
            className="text-white  bg-blue-900 hover:bg-green-950 focus:ring-4 focus:outline-none focus:ring-blue-300 font-medium rounded-lg text-sm px-4 py-2 text-center dark:bg-blue-600 dark:hover:bg-blue-700 dark:focus:ring-blue-800"
          >
            {"Chat Seller"} 
                     </button>
              </div>
            </li>
  )
}
