"use client"
import React from 'react';
import { useState } from "react";
import SearchItem from './searchItem';
import Search from './search';


export default function SearchToggle() {
    const [isOpen, setIsOpen] = useState(true);
    const toggleOpen = () => {
      setIsOpen((open) => !open);
    };
  return (
    <li class="static" data-twe-nav-item-ref data-twe-dropdown-ref>
            <a
              class="flex items-center whitespace-nowrap py-2 pe-2 text-black/60 transition duration-200 hover:text-black/80 hover:ease-in-out focus:text-black/80 active:text-black/80 motion-reduce:transition-none dark:text-white/60 dark:hover:text-white/80 dark:focus:text-white/80 dark:active:text-white/80 lg:px-2"
              href="#"
              type="button"
              id="dropdownMenuButtonY"
              data-twe-dropdown-toggle-ref
              aria-expanded="false"
              data-twe-nav-link-ref
              onClick={toggleOpen}

              >Search Products
              <span class="ms-2 [&>svg]:h-5 [&>svg]:w-5">
                <svg
                  xmlns="http://www.w3.org/2000/svg"
                  viewBox="0 0 20 20"
                  fill="currentColor">
                  <path
                    fill-rule="evenodd"
                    d="M5.23 7.21a.75.75 0 011.06.02L10 11.168l3.71-3.938a.75.75 0 111.08 1.04l-4.25 4.5a.75.75 0 01-1.08 0l-4.25-4.5a.75.75 0 01.02-1.06z"
                    clip-rule="evenodd" />
                </svg>
              </span>
            </a>
            <div
              className={`${
                isOpen ? "hidden" : ""
              } absolute left-0 right-0 top-full z-[1000] mt-0  w-full border-none bg-white bg-clip-padding shadow-lg data-[twe-dropdown-show]:block dark:bg-neutral-700`}
              aria-labelledby="dropdownMenuButtonY"
              data-twe-dropdown-menu-ref>
              <div class="px-6 py-5 lg:px-8">
                <div class="grid gap-6 md:grid-cols-2 xl:grid-cols-4">
<Search/>
                  <SearchItem/>
                  
                  
                  
                  
                  
                </div>
              </div>
            </div>
          </li>
  )
}
