"use client";
import { useState } from "react";
import Pagination from "../components/pagination";
import ListItem from "./listItem";
import useSWR from "swr";
{
  /*
async function getVenues() {
  //Imitate Delay
  await new Promise((resolve) => setTimeout(resolve, 3000));

  const endPoint = "https://cloud.rentandflex.com/api/market";
  const res = await fetch(endPoint, {
    next: {
      revalidate: 60 * 60,
    },
  });
  return res.json();
}*/
}

const fetcher = (...args) => fetch(...args).then((response) => response.json());

function Lists(props) {
  const [currentPage, setCurrentPage] = useState(1);

  let endPoint = "https://api.247tranzact.com/api/market/";
  const { isLoading, data: market, error } = useSWR(endPoint, fetcher);
  if (isLoading) return <p>{"data is loading"}</p>;
  if (error) return <p>{"Error in Connection"}</p>;

  {
    /* const market = [];
  for (const key in data) {
    market.push(data[key]);
  }
  console.log(market);*/
  }

  const recordsPerPage = 20;
  const lastIndex = currentPage * recordsPerPage;
  const firstIndex = lastIndex - recordsPerPage;
  const orders = market.slice(firstIndex, lastIndex);

  const paginate = (n) => setCurrentPage(n);

  return (
    <div>
      <div className="-mx-4 flex flex-wrap">
        <ListItem post={orders} />
      </div>
      <Pagination
        order={market.length}
        recordsPerPage={recordsPerPage}
        paginate={paginate}
      />
    </div>
  );
}

export default Lists;
