import Link from "next/link";
function Venue({ list }) {
 // console.log(list)
  const { title,city,state, category, profilePic, _id, slug, description } = list;
  const src = "https://api.247tranzact.com/images/";

  return (
    <div className="w-full px-4 md:w-1/2 xl:w-1/3">
      <div className="mb-10 overflow-hidden rounded-lg bg-white shadow-1 duration-300 hover:shadow-3 dark:bg-dark-2 dark:shadow-card dark:hover:shadow-3">
        <img src={src + profilePic} alt={title} className="w-full h-fit" />
        <div className="p-8 text-center sm:p-9 md:p-7 xl:p-9">
          <div className="relative z-10 mx-7 -mt-20 rounded-lg bg-white px-3 py-[34px] text-center shadow-portfolio dark:bg-dark-2 dark:shadow-box-dark">
            <span className="mb-2 block text-sm font-medium text-primary">
              {category}
            </span>
            <h3 className="mb-5 text-xl font-bold text-dark dark:text-white">
              <Link
                href={{
                  pathname: `/listing/${_id}`,
                  query: slug,
                }}
              >
                {title}
              </Link>{" "}
            </h3>
            <p className="text-sm text-body-color dark:text-dark-6">
              <span className="text-red-700">{city},{state}</span>
            </p>
            <p className="mb-7 text-base leading-relaxed text-body-color dark:text-dark-6">
              {description.slice(0, 200)}...
            </p>
            <Link
              className="inline-block rounded-md border border-stroke px-7 py-[10px] text-sm font-medium text-body-color transition hover:border-primary hover:bg-primary hover:text-white dark:border-dark-3 dark:text-dark-6"
              href={{
                pathname: `/listing/${_id}`,
                query: slug,
              }}
            >
              View Details
            </Link>{" "}
          </div>
        </div>
      </div>
    </div>
  );
}

export default Venue;
