import Link from "next/link";
import Form from "./form";

function Page(props) {
  return (
    <>
      <section>
        <div class="relative flex justify-center max-h-full overflow-hidden lg:px-0 md:px-12">
          <div class="relative z-10 flex flex-col flex-2 px-4 py-10 bg-white lg:border-r lg:py-24 md:flex-none md:px-28 sm:justify-center">
            <div class="w-full max-w-md mx-auto md:max-w-sm md:px-0 md:w-96 sm:px-4">
              <div class="flex flex-col">
                <h1 class="text-3xl font-semibold tracking-tighter text-gray-900">
                  Manage your Shop,
                  <span class="text-gray-600">from any location</span>
                </h1>
                <p class="mt-4 text-base font-medium text-gray-500">
                  A quick resource to manage and grow your shop. Enroll in few steps
                </p>
              </div>
              <div class="mt-10">
              <span >Have an account, <Link className="text-red-500" href="https://app.247tranzact.com/">Login</Link> </span>

                <button
                  class="inline-flex items-center justify-center w-full h-12 gap-3 px-5 py-3 font-medium duration-200 bg-gray-100 rounded-xl hover:bg-gray-200 focus:ring-2 focus:ring-offset-2 focus:ring-blue-500"
                  type="button"
                  aria-label="Sign in with Google"
                >
                  <span>Sign Up: Complete this Multi-Form</span>
                </button>
              </div>
              <br />
              <Form />
            </div>
          </div>
          <div class="hidden bg-white lg:block lg:flex-1 lg:relative sm:contents">
            <div
              class="absolute inset-0 object-cover w-full h-full bg-white"
              alt=""
              height="1866"
              width="1000"
            >
              <img
                class="object-cover object-center w-full h-auto bg-gray-200"
                src="image/Business-woman-typing-in-a-phone.JPG"
                alt="Business-woman-typing-in-a-phone"
                width="1310"
                height="873"
              />
            </div>
          </div>
        </div>
      </section>
    </>
  );
}

export default Page;
