import Link from "next/link";
import Image from "next/image";
import { imgUrl } from "../components/http";
function SinglePost({ list }) {
  return (
    <div className="w-full px-4 md:w-1/2 lg:w-1/3">
      <div className="mb-10 w-full">
        <div className="mb-8 overflow-hidden rounded">
          <img
            src={imgUrl + list.photo}
            alt="image"
            className="w-full"
            width={500}
            height={100}
          />
        </div>
        <div>
          <div className="mb-5 inline-block rounded bg-primary px-4 py-1 text-center text-xs font-semibold leading-loose text-blue-800">
            {new Date(list.createdAt).toDateString()}
          </div>
          <div className="mb-5 inline-block rounded bg-primary px-4 py-1 text-right text-xs font-semibold leading-loose text-blue-800">
            By: {list.username}
          </div>

          <h3 className="mb-4 inline-block text-xl font-semibold text-dark hover:text-primary sm:text-2xl lg:text-xl xl:text-2xl dark:text-white">
            <Link
              href={{
                pathname: `/blog/${list.id}`,
                query: list.slug,
              }}
            >
              {list.title}
            </Link>
          </h3>

          <p className="text-base text-body-color dark:text-dark-6">
            {list.description.slice(0, 200)}...
          </p>
        </div>
      </div>
    </div>
  );
}

export default SinglePost;
