"use client"
import React from 'react';
import { useState } from "react";
import SearchToggle from './searchtoggle';
import SearchBrand from './searchBrand';


export default function Megamenu3() {
    const [isOpen, setIsOpen] = useState(true);
    const toggleOpen = () => {
      setIsOpen((open) => !open);
    };
  return (
    <div><nav
    className="relative flex w-full items-center justify-between bg-zinc-50 py-2 shadow-dark-mild dark:bg-neutral-700 lg:flex-wrap lg:justify-start"
    data-twe-navbar-ref>
    <div className="px-6">
      <button
        className="block border-0 bg-transparent px-2 text-black/50 hover:no-underline hover:shadow-none focus:no-underline focus:shadow-none focus:outline-none focus:ring-0 dark:text-neutral-200 lg:hidden"
        type="button"
        data-twe-collapse-init
        data-twe-target="#navbarSupportedContent4"
        aria-controls="navbarSupportedContent4"
        aria-expanded="false"
        aria-label="Toggle navigation"
        onClick={toggleOpen}

        >
        <span
          className="[&>svg]:w-7 [&>svg]:stroke-black/50 dark:[&>svg]:stroke-neutral-200">
          <svg
            xmlns="http://www.w3.org/2000/svg"
            viewBox="0 0 24 24"
            fill="currentColor">
            <path
              fill-rule="evenodd"
              d="M3 6.75A.75.75 0 013.75 6h16.5a.75.75 0 010 1.5H3.75A.75.75 0 013 6.75zM3 12a.75.75 0 01.75-.75h16.5a.75.75 0 010 1.5H3.75A.75.75 0 013 12zm0 5.25a.75.75 0 01.75-.75h16.5a.75.75 0 010 1.5H3.75a.75.75 0 01-.75-.75z"
              clip-rule="evenodd" />
          </svg>
        </span>
      </button>
      <div
        className={`${
            isOpen ? "hidden" : ""
          } !visible  flex-grow basis-[100%] items-center lg:!flex lg:basis-auto`}
        id="navbarSupportedContent4"
        data-twe-collapse-item>
        <ul className="me-auto flex flex-row" data-twe-navbar-nav-ref>
           
        <SearchBrand/>
   

    <SearchToggle/>
        </ul>
      </div>
    </div>
  </nav></div>
  )
}
