"use client";

function Pagination({ recordsPerPage, order, paginate }) {
  const npage = Math.ceil(order / recordsPerPage);
  const numbers = [...Array(npage + 1).keys()].slice(1);
  return (
    <div>
      <div className="flex justify-center py-10 dark:bg-dark ">
        {numbers.map((n, key) => {
          return (
            <ul className="flex items-center justify-center gap-1 px-2">
              <li>
                <button
                  className="flex h-10 min-w-10 items-center justify-center rounded-lg bg-black px-2 text-white hover:bg-gray-2 dark:text-white dark:hover:bg-white/5"
                  onClick={() => paginate(n)}
                  key={key}
                >
                  {n}
                </button>
              </li>
            </ul>
          );
        })}
      </div>
    </div>
  );
}

export default Pagination;
