import Footer from "./components/footer";
import Megamenu from "./components/megamenu";
import Megamenu3 from "./components/megamenu3";
import Nav from "./components/Nav";
import Navsearch from "./components/navsearch";
import { ThemeProvider } from "./components/theme-provider";
import "./globals.css";
import { Inter } from "next/font/google";
import Providers from "./components/Providers";

const inter = Inter({ subsets: ["latin"] });

export const metadata = {
  title: "247Tranzact",
  description: "Buy and Sell Goods from verified Sellers Around You",
};

export default function RootLayout({ children }) {
  return (
    <html lang="en">
      <body className={inter.className}>
      <Providers>
        <Navsearch />
        <Megamenu3/>
        {children}
        <Footer />
        </Providers>

      </body>
    </html>
  );
}
