'use client'

import Link from 'next/link'
import React, { useEffect, useState } from 'react'
import http from '../components/http'
import Content from './content'
import { redirect } from 'next/navigation'
import { isTokenExpired } from '../../lib/checkToken'


export default function VerifyPage({searchParams}) {
   // console.log(searchParams)
    const [verified, setVerified] = useState(false)
    const [error, setError] = useState(false)
    const [loading, setLoading] = useState(true)

    const {email, verifyToken} = searchParams || null
    //console.log(email)
         const tokenStatus = isTokenExpired(verifyToken)
      if(tokenStatus===false){

      useEffect(() => {
        const fetchToken = async () => {
         try{
          const res = await http.get(`email/verify-email?email=${email}&verifyToken=${verifyToken}`);
          console.log(res)
            setVerified(true)
            setLoading(false)
          
          //const data = await res.json();
          //setProduct(data);
         } 
         catch (err){ 
          console.log(err)
          setError(true)
           setLoading(false)
         }
        };
    
        fetchToken();
      }, [])
  
      }
    
      if(!verifyToken || !email||tokenStatus===true){
        redirect('/register')
    }
else
  return (
 (<Content email = {email}/>)





  )
}
