
import NextAuth from "next-auth"
import Credentials from 'next-auth/providers/credentials'
import { redirect } from "next/navigation"
import http from "./app/components/http";

export const {handlers,auth,signIn,signOut} = NextAuth({
  basePath: "/api/auth",
  trustHost: true,
  secret: process.env.AUTH_SECRET,
  session:{
    strategy: 'jwt',
    maxAge:  24 *60*60,
  }, 
  pages:{
    signIn: '/auth/sign_in',
  },
  providers: [
    Credentials({
      credentials:{
        Email:{},
        Password:{}
      },
       authorize: async(credentials, request)=>{
      const {email,password} = credentials;
      try{const res = await http.post("/auth/login", credentials);
        console.log(res.data);
        const {email,id, username} =res.data;
          return {email:email,id:id,name:username}
      } 
       catch(err) {
        console.log(err)
         return null
       }  
      }
    }

    )
  ],
  callbacks:{

    async jwt({token,user}){
      if (user) {
        return {
          ...token,
          id:user.id,
        };
      }
      return token;
    },
    async session({session, token}){
    //  console.log("session callback", {session,token})
      return {
        ...session,
        user:{
          ...session.user,
          id:token.id

        }
      }
    }

  }
})




    



 
